(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20510,        503]*)
(*NotebookOutlinePosition[     21329,        531]*)
(*  CellTagsIndexPosition[     21285,        527]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Satellite orbits", "Title"],

Cell["\<\
code and documentation by jph - download from www.hakenberg.de\
\>", "Text"],

Cell[TextData[{
  StyleBox["Setup instructions:",
    FontWeight->"Bold"],
  "\n\[Bullet] place the file \"earth.jpg\" to the location \"c:/earth.jpg\"\n\
\[Bullet] evaluate the notebook top to bottom"
}], "Text"],

Cell[CellGroupData[{

Cell["Utilities", "Section"],

Cell[CellGroupData[{

Cell["Helper functions", "Subsubsection"],

Cell[BoxData[{
    \(Off[General::spell]; \ \), "\n", 
    \(Off[General::spell1]; \), "\n", 
    \(\[ScriptS] := FullSimplify[#1, assume] &; \), "\n", 
    \(\[CapitalTau]\[FivePointedStar][v_, n_] := 
      Array[v\_##1 &, n]; \), "\n", 
    \(X_\[SmallCircle]\[Phi]_ := 
      X /. \[CapitalTau]\[FivePointedStar][x, 
            Length[\[Phi]]] \[ShortRightArrow] \[Phi]; \), "\n", 
    \(\[CapitalMu]d[X_List, r_Integer, n_Integer] := 
      Transpose[Array[D[X, x\_#1] &, {n}], 
        Flatten[{r + 1, Range[r]}]]; \), "\n", 
    \(\[CapitalMu]d[X_List, r_Integer] := \[CapitalMu]d[X, r, 
        Length[X]]; \), "\n", 
    \(\[CapitalMu]d[X_, n_Integer] := Array[D[X, x\_#1] &, n]; \), "\n", 
    \(x_Symbol \[ShortRightArrow] y_List := 
      Array[x\_#1 \[Rule] y\[LeftDoubleBracket]#1\[RightDoubleBracket] &, 
        Length[y]]; \), "\n", 
    \(x_List \[ShortRightArrow] y_List := 
      Array[x\[LeftDoubleBracket]#1\[RightDoubleBracket] \[Rule] 
            y\[LeftDoubleBracket]#1\[RightDoubleBracket] &, 
        Min[Length[x], Length[y]]]; \), "\n", 
    \(x_List \[ShortRightArrow] 0 := 
      Array[x\[LeftDoubleBracket]#1\[RightDoubleBracket] \[Rule] 0 &, 
        Length[x]]; \)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Earth map", "Subsubsection"],

Cell[BoxData[{
    \(\(map = Import["\<c:/earth.jpg\>"];\)\), "\[IndentingNewLine]", 
    \(\(map\[LeftDoubleBracket]1, 
          2\[RightDoubleBracket] = {{\(-\[Pi]\), \(-\[Pi]\)/2}, {\[Pi], \[Pi]/
              2}};\)\), "\[IndentingNewLine]", 
    \(\(map\[LeftDoubleBracket]2, 2\[RightDoubleBracket] = 
        Round[map\[LeftDoubleBracket]2, 2\[RightDoubleBracket]\ 4/5 + {1, 
              1}];\)\), "\[IndentingNewLine]", 
    \(\(map\[LeftDoubleBracket]3\[RightDoubleBracket] = 
        PlotRange \[Rule] {{\(-\[Pi]\), \[Pi]}, {\(-\[Pi]\)/2, \[Pi]/
                2}};\)\), "\[IndentingNewLine]", 
    \(\(Show[map];\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Runge Kutta 4th order", "Subsubsection"],

Cell["\<\
Use compiled function and implement Runge Kutta. Eccentricity close to 1 \
demands very small step size.\
\>", "Text"],

Cell[BoxData[{
    \(\(Clear[h, T];\)\), "\[IndentingNewLine]", 
    \(\(SRungeKutta[X_] := 
        Module[{t = X\[LeftDoubleBracket]1\[RightDoubleBracket], 
            x = X\[LeftDoubleBracket]2\[RightDoubleBracket], k1, k2, k3, 
            k4}, \[IndentingNewLine]k1 = \[CapitalPhi][t, 
              x]; \[IndentingNewLine]k2 = \[CapitalPhi][t +  .5\ h, 
              x +  .5\ h\ k1]; \[IndentingNewLine]k3 = \[CapitalPhi][
              t +  .5\ h, 
              x +  .5\ h\ k2]; \[IndentingNewLine]k4 = \[CapitalPhi][t + h, 
              x + h\ k3]; \[IndentingNewLine]{t + h, 
            x + h\ {1\/6, 1\/3, 1\/3, 1\/6} . {k1, k2, k3, 
                    k4}}];\)\)}], "Input"],

Cell[BoxData[{\(\[CapitalNu] = 
        1000;\), "\[IndentingNewLine]", \(SIntegrate[X_, T_] := 
        Module[{res}, 
          h = T/\[CapitalNu]; \[IndentingNewLine]res = 
            NestList[
              SRungeKutta, {0, 
                X}, \[CapitalNu]]; \[IndentingNewLine]\(\(Interpolation[
                  Transpose[{res\[LeftDoubleBracket]All, 
                        1\[RightDoubleBracket], #1}]]\)[t] &\) /@ 
            Transpose[
              res\[LeftDoubleBracket]All, 
                2, {1, 2, 
                  3}\[RightDoubleBracket]]];\), "\[IndentingNewLine]", \
\(STarget[X_, T_] := 
        Module[{res}, 
          h = T/\[CapitalNu]; \[IndentingNewLine]Nest[
            SRungeKutta, {0, X}, \[CapitalNu]]];\), "\[IndentingNewLine]", 
    RowBox[{\(SInit[\[Mu]_, a_, \[Epsilon]_, \[Omega]_, i_, \[CapitalOmega]_, 
        n_]\), ":=", 
      RowBox[{"Module", "[", 
        RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
              RowBox[{"R\[CapitalOmega]", "=", 
                RowBox[{"MatrixExp", "[", 
                  RowBox[{
                    RowBox[{"(", GridBox[{
                          {"0", \(-x\_3\), \(x\_2\)},
                          {\(x\_3\), "0", \(-x\_1\)},
                          {\(-x\_2\), \(x\_1\), "0"}
                          }], ")"}], 
                    "\[SmallCircle]", \({0, 
                      0, \[CapitalOmega]  \[Pi]\/180}\)}], "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Ri", "=", 
                RowBox[{"MatrixExp", "[", 
                  RowBox[{
                    RowBox[{"(", GridBox[{
                          {"0", \(-x\_3\), \(x\_2\)},
                          {\(x\_3\), "0", \(-x\_1\)},
                          {\(-x\_2\), \(x\_1\), "0"}
                          }], ")"}], 
                    "\[SmallCircle]", \({i  \[Pi]\/180, 0, 0}\)}], "]"}]}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"R\[Omega]", "=", 
                RowBox[{"MatrixExp", "[", 
                  RowBox[{
                    RowBox[{"(", GridBox[{
                          {"0", \(-x\_3\), \(x\_2\)},
                          {\(x\_3\), "0", \(-x\_1\)},
                          {\(-x\_2\), \(x\_1\), "0"}
                          }], ")"}], 
                    "\[SmallCircle]", \({0, 0, \[Omega]  \[Pi]\/180}\)}], 
                  "]"}]}], ",", 
              "\[IndentingNewLine]", \(rp = a\ \((1 - \[Epsilon])\)\), ",", 
              "mat"}], "}"}], 
          ",", \(mat = 
            R\[CapitalOmega] . Ri . 
              R\[Omega]; \[IndentingNewLine]{Flatten[{mat . {rp, 0, 0}, 
                mat . {0, \@\(\(\[Mu]\ \((1 + \[Epsilon])\)\)\/\(a\ \((1 - \
\[Epsilon])\)\)\), 0}}], T = n\ 2\ \[Pi]\ \@\(a\^3\/\[Mu]\)}\)}], 
        "]"}]}]}], "Input"],

Cell[BoxData[{
    \(\(assume = {0 < x\_1 < \[CurlyEpsilon], 0 < x\_2 < \[CurlyEpsilon], 
          0 < x\_3 < \[CurlyEpsilon]};\)\), "\[IndentingNewLine]", 
    \(\(\[Phi] = {\@\(x\_1\%2 + x\_2\%2 + x\_3\%2\), ArcTan[x\_1, x\_2], 
          ArcTan[\@\(x\_1\%2 + x\_2\%2\), 
            x\_3]};\)\), "\[IndentingNewLine]", 
    \(\(\[CurlyPhi] = \(x\_1\) {Cos[x\_2]\ Cos[x\_3], Sin[x\_2]\ Cos[x\_3], 
            Sin[x\_3]};\)\), "\[IndentingNewLine]", 
    \(d\[Phi] = \[CapitalMu]d[\[Phi], 1] // \[ScriptS]; 
    d\[Phi] // MatrixForm\), "\[IndentingNewLine]", 
    \(d\[CurlyPhi] = \[CapitalMu]d[\[CurlyPhi], 1] // \[ScriptS]; 
    d\[CurlyPhi] // MatrixForm\)}], "Input"],

Cell[BoxData[{
    \(\(r\_E = 6378.14;\)\), "\[IndentingNewLine]", 
    \(\(\[Mu]\_E = 398900. ;\)\), "\[IndentingNewLine]", 
    \(\(\[Mu]\_S = 1.327\ 10\^11;\)\), "\[IndentingNewLine]", 
    \(\(\[Iota]\_E = 23.452\ \[Pi]/180;\)\), "\[IndentingNewLine]", 
    \(\(\[Sigma]\_E = 86164.11605509756;\)\), "\[IndentingNewLine]", 
    \(\(d\_E = 86400;\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Satellite around Earth", "Subsubsection"],

Cell[TextData[{
  "This time we take the real ",
  Cell[BoxData[
      \(TraditionalForm\`J\_2\)]],
  " coefficient."
}], "Text"],

Cell[BoxData[{
    \(\(\[Upsilon]J = {0, 
          1082.6*^-6, \(-2.53*^-6\), \(-1.62*^-6\), \(-0.23*^-6\), 
          0.54*^-6};\)\), "\[IndentingNewLine]", 
    \(\(\[Upsilon]C = {{}, {0, 1.57*^-6}, {\(-2.19*^-6\), 
            0.31*^-6, \(-0.1*^-6\)}, {0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 
            0, 0, 0}};\)\), "\[IndentingNewLine]", 
    \(\(\[Upsilon]S = {{}, {0, \(-0.9*^-6\)}, \(-{0.27*^-6, 0.21*^-6, 
              0.2*^-6}\), {0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
            0}};\)\)}], "Input"],

Cell[BoxData[{
    \(\(\[CapitalUpsilon][\[Rho]_, \[Theta]_, \[Lambda]_] := \(-\(\[Mu]\_E\/\
\[Rho]\)\) + \(\[Mu]\_E\/\[Rho]\) 
            Sum[\(\((r\_E\/\[Rho])\)\^n\) \[Upsilon]J\[LeftDoubleBracket]
                    n\[RightDoubleBracket]\ LegendreP[n, 
                    0, \(-Sin[\[Theta]]\)] + \ \
\[IndentingNewLine]Sum[\(\((r\_E\/\[Rho])\)\^n\) \((\[Upsilon]C\
\[LeftDoubleBracket]n, m\[RightDoubleBracket]\ Cos[
                            m\ \[Lambda]] + \[Upsilon]S\[LeftDoubleBracket]n, 
                            m\[RightDoubleBracket]\ Sin[
                            m\ \[Lambda]])\)\ LegendreP[n, 
                      m, \(-Sin[\[Theta]]\)], {m, n}], \[IndentingNewLine]{n, 
                2, 6}];\)\), "\[IndentingNewLine]", 
    \(\(U = \[CapitalUpsilon][x\_1, x\_3, x\_2] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(\(dU = 
        Simplify[\[CapitalMu]d[U, 3]\[SmallCircle]\[Phi]] . 
          d\[Phi];\)\)}], "Input"],

Cell[BoxData[{
    \(\(hU = dU\[SmallCircle]{x, y, z};\)\), "\[IndentingNewLine]", 
    \(\(cU = Compile[{x, y, z}, Evaluate[hU]];\)\), "\[IndentingNewLine]", 
    \(\(SATELLITE[t_, X_] := 
        Join[X\[LeftDoubleBracket]{4, 5, 6}\[RightDoubleBracket], \(-cU @@ 
              X\[LeftDoubleBracket]{1, 2, 
                  3}\[RightDoubleBracket]\)];\)\), "\[IndentingNewLine]", 
    \(SATELLITE[0, {1000, 0, 0, 0, 0, 0}]\)}], "Input"],

Cell[BoxData[{
    \(\(\[DoubleStruckCapitalP][\[GothicT]_] := 
        With[{X = \[Phi]\[SmallCircle]\((pos /. 
                    t \[Rule] \[GothicT])\)}, {Mod[
              X\[LeftDoubleBracket]2\[RightDoubleBracket] - \(2\ \[Pi]\ \
\[GothicT]\)\/\[Sigma]\_E, 2  \[Pi], \(-\[Pi]\)], 
            X\[LeftDoubleBracket]3\[RightDoubleBracket]}];\)\), "\
\[IndentingNewLine]", 
    \(\(drwfnc := 
        Line /@ Module[{c1, pnto, pntn, lst = {}, cur = {}, h = T/100, 
              t = 0. , c, 
              stp}, \[IndentingNewLine]stp = {h, h/4, h/16, 
                h/64}; \[IndentingNewLine]While[
              t < T - h, \[IndentingNewLine]pnto = \[DoubleStruckCapitalP][
                  t]; \[IndentingNewLine]pntn = \(\[DoubleStruckCapitalP][
                      t + #1] &\) /@ stp; \[IndentingNewLine]c = 
                Count[\(Norm[#1 - pnto] -  .1 &\) /@ pntn, _?
                    Positive]; \[IndentingNewLine]If[
                c < Length[stp], \[IndentingNewLine]AppendTo[cur, 
                  pntn\[LeftDoubleBracket]c + 
                      1\[RightDoubleBracket]]; \[IndentingNewLine]t += 
                  stp\[LeftDoubleBracket]c + 
                      1\[RightDoubleBracket];, \[IndentingNewLine]If[
                  Sign[pnto\[LeftDoubleBracket]1\[RightDoubleBracket]\ pntn\
\[LeftDoubleBracket]1, 
                          1\[RightDoubleBracket]] \[Equal] \(-1\), \
\[IndentingNewLine]AppendTo[cur, 
                    pntn\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket] + 
                      pnto\[LeftDoubleBracket]1\[RightDoubleBracket]\ {2  \
\[Pi], 0}]; \[IndentingNewLine]AppendTo[lst, 
                    cur]; \[IndentingNewLine]cur = {pnto - 
                        pnto\[LeftDoubleBracket]1\[RightDoubleBracket]\ {2  \
\[Pi], 0}};, \[IndentingNewLine]AppendTo[lst, cur]; 
                  cur = {};\[IndentingNewLine]]; \[IndentingNewLine]t += 
                  stp\[LeftDoubleBracket]\(-1\)\[RightDoubleBracket];\
\[IndentingNewLine]];\[IndentingNewLine]]; \[IndentingNewLine]AppendTo[lst, 
              cur]; lst\[IndentingNewLine]];\)\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Orbits", "Section"],

Cell[CellGroupData[{

Cell["Galileo satellites", "Subsubsection"],

Cell[BoxData[{
    \(\(\[CapitalPhi] = SATELLITE;\)\), "\[IndentingNewLine]", 
    \(\(\[CapitalNu] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(Shome = 
        SInit[\[Mu]\_E, r\_E + 23222, 0, 0, 55, 13, 
          3.05];\)\), "\[IndentingNewLine]", 
    \(\(pos = SIntegrate @@ Shome;\)\), "\[IndentingNewLine]", 
    \(\(pP = 
        ParametricPlot3D[pos, {t, 0, T}, DisplayFunction \[Rule] Identity, 
          PlotPoints \[Rule] 200];\)\), "\[IndentingNewLine]", 
    \(\(pS = 
        ParametricPlot3D[
          Evaluate[\[CurlyPhi] /. 
              x\_1 \[Rule] 
                r\_E], {x\_2, \(-\[Pi]\), \[Pi]}, {x\_3, \(-\[Pi]\)/2, \[Pi]/
              2}, DisplayFunction \[Rule] 
            Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[pP, pS, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[
    \(\(Show[{map, 
          Graphics[\[IndentingNewLine]Flatten[{\[IndentingNewLine]RGBColor[1, 
                  1, 0], \[IndentingNewLine]drwfnc, \
\[IndentingNewLine]Table[{PointSize[
                      300/\((\[Phi]\[SmallCircle]
                              pos)\)\[LeftDoubleBracket]1\[RightDoubleBracket]\
], RGBColor[1, 1 -  .7\ t/T, 0], Point[\[DoubleStruckCapitalP][t]]}, {t, 0, 
                    T - 1, 60\ 60}]\[IndentingNewLine]}]]}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["GPS satellites", "Subsubsection"],

Cell[BoxData[{
    \(\(\[CapitalPhi] = SATELLITE;\)\), "\[IndentingNewLine]", 
    \(\(\[CapitalNu] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(Shome = 
        SInit[\[Mu]\_E, 26600, 0, 0, 55, 13, 
          2.05];\)\), "\[IndentingNewLine]", 
    \(\(pos = SIntegrate @@ Shome;\)\), "\[IndentingNewLine]", 
    \(\(pP = 
        ParametricPlot3D[pos, {t, 0, T}, DisplayFunction \[Rule] Identity, 
          PlotPoints \[Rule] 200];\)\), "\[IndentingNewLine]", 
    \(\(pS = 
        ParametricPlot3D[
          Evaluate[\[CurlyPhi] /. 
              x\_1 \[Rule] 
                r\_E], {x\_2, \(-\[Pi]\), \[Pi]}, {x\_3, \(-\[Pi]\)/2, \[Pi]/
              2}, DisplayFunction \[Rule] 
            Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[pP, pS, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[
    \(\(Show[{map, 
          Graphics[
            Flatten[{\[IndentingNewLine]RGBColor[1, 1, 
                  0], \[IndentingNewLine]drwfnc, \
\[IndentingNewLine]Table[{PointSize[
                      300/\((\[Phi]\[SmallCircle]
                              pos)\)\[LeftDoubleBracket]1\[RightDoubleBracket]\
], RGBColor[1, 1 -  .7\ t/T, 0], Point[\[DoubleStruckCapitalP][t]]}, {t, 0, 
                    T - 1, 60\ 60}]\[IndentingNewLine]}]]}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Geostationary with inclination", "Subsubsection"],

Cell[BoxData[{
    \(\(\[CapitalPhi] = SATELLITE;\)\), "\[IndentingNewLine]", 
    \(\(\[CapitalNu] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(Shome = 
        SInit[\[Mu]\_E, 42174.737794132, 0, 0, 40, \(-23\), 
          1.05];\)\), "\[IndentingNewLine]", 
    \(\(pos = SIntegrate @@ Shome;\)\), "\[IndentingNewLine]", 
    \(\(pP = 
        ParametricPlot3D[pos, {t, 0, T}, DisplayFunction \[Rule] Identity, 
          PlotPoints \[Rule] 200];\)\), "\[IndentingNewLine]", 
    \(\(pS = 
        ParametricPlot3D[
          Evaluate[\[CurlyPhi] /. 
              x\_1 \[Rule] 
                r\_E], {x\_2, \(-\[Pi]\), \[Pi]}, {x\_3, \(-\[Pi]\)/2, \[Pi]/
              2}, DisplayFunction \[Rule] 
            Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[pP, pS, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[
    \(\(Show[{map, 
          Graphics[
            Flatten[{\[IndentingNewLine]RGBColor[1, 1, 
                  0], \[IndentingNewLine]drwfnc, \
\[IndentingNewLine]Table[{PointSize[
                      300/\((\[Phi]\[SmallCircle]
                              pos)\)\[LeftDoubleBracket]1\[RightDoubleBracket]\
], RGBColor[1, 1 -  .7\ t/T, 0], Point[\[DoubleStruckCapitalP][t]]}, {t, 0, 
                    T - 1, T/40}]\[IndentingNewLine]}]]}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Molniya", "Subsubsection"],

Cell[BoxData[{
    \(\(\[CapitalPhi] = SATELLITE;\)\), "\[IndentingNewLine]", 
    \(\(\[CapitalNu] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(Shome = 
        SInit[\[Mu]\_E, 26450, 0.722, \(-90\), 63.4, 67, 
          2.05];\)\), "\[IndentingNewLine]", 
    \(\(pos = SIntegrate @@ Shome;\)\), "\[IndentingNewLine]", 
    \(\(pP = 
        ParametricPlot3D[pos, {t, 0, T}, DisplayFunction \[Rule] Identity, 
          PlotPoints \[Rule] 200];\)\), "\[IndentingNewLine]", 
    \(\(pS = 
        ParametricPlot3D[
          Evaluate[\[CurlyPhi] /. 
              x\_1 \[Rule] 
                r\_E], {x\_2, \(-\[Pi]\), \[Pi]}, {x\_3, \(-\[Pi]\)/2, \[Pi]/
              2}, DisplayFunction \[Rule] 
            Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[pP, pS, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[
    \(\(Show[{map, 
          Graphics[
            Flatten[{\[IndentingNewLine]RGBColor[1, 1, 
                  0], \[IndentingNewLine]drwfnc, \
\[IndentingNewLine]Table[{PointSize[ .005 + 
                        50/\((\[Phi]\[SmallCircle]
                                pos)\)\[LeftDoubleBracket]1\
\[RightDoubleBracket]], RGBColor[1, 1 -  .7\ t/T, 0], 
                    Point[\[DoubleStruckCapitalP][t]]}, {t, 0, T - 1, 
                    10\ 60}]\[IndentingNewLine]}]]}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["International Space Station", "Subsubsection"],

Cell[BoxData[{
    \(\(\[CapitalPhi] = SATELLITE;\)\), "\[IndentingNewLine]", 
    \(\(\[CapitalNu] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(Shome = 
        SInit[\[Mu]\_E, r\_E + 370, 0, 0, 51, \(-23\), 
          2.05];\)\), "\[IndentingNewLine]", 
    \(\(pos = SIntegrate @@ Shome;\)\), "\[IndentingNewLine]", 
    \(\(pP = 
        ParametricPlot3D[pos, {t, 0, T}, DisplayFunction \[Rule] Identity, 
          PlotPoints \[Rule] 200];\)\), "\[IndentingNewLine]", 
    \(\(pS = 
        ParametricPlot3D[
          Evaluate[\[CurlyPhi] /. 
              x\_1 \[Rule] 
                r\_E], {x\_2, \(-\[Pi]\), \[Pi]}, {x\_3, \(-\[Pi]\)/2, \[Pi]/
              2}, DisplayFunction \[Rule] 
            Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[pP, pS, DisplayFunction \[Rule] $DisplayFunction, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[BoxData[
    \(\(Show[{map, 
          Graphics[
            Flatten[{\[IndentingNewLine]RGBColor[1, 1, 
                  0], \[IndentingNewLine]drwfnc, \
\[IndentingNewLine]Table[{PointSize[
                      70/\((\[Phi]\[SmallCircle]
                              pos)\)\[LeftDoubleBracket]1\[RightDoubleBracket]\
], RGBColor[1, 1 -  .7\ t/T, 0], Point[\[DoubleStruckCapitalP][t]]}, {t, 0, 
                    T - 1, 5\ 60}]\[IndentingNewLine]}]]}];\)\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{61, 1680}, {0, 1005}},
WindowSize->{1233, 914},
WindowMargins->{{57, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification->1.25,
StyleDefinitions -> "ArticleClassic.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 33, 0, 105, "Title"],
Cell[1812, 55, 86, 2, 33, "Text"],
Cell[1901, 59, 213, 5, 75, "Text"],

Cell[CellGroupData[{
Cell[2139, 68, 28, 0, 69, "Section"],

Cell[CellGroupData[{
Cell[2192, 72, 41, 0, 39, "Subsubsection"],
Cell[2236, 74, 1212, 24, 246, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3485, 103, 34, 0, 39, "Subsubsection"],
Cell[3522, 105, 642, 11, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4201, 121, 46, 0, 39, "Subsubsection"],
Cell[4250, 123, 128, 3, 33, "Text"],
Cell[4381, 128, 691, 12, 181, "Input"],
Cell[5075, 142, 2843, 61, 423, "Input"],
Cell[7921, 205, 675, 11, 153, "Input"],
Cell[8599, 218, 365, 6, 142, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9001, 229, 47, 0, 39, "Subsubsection"],
Cell[9051, 231, 129, 5, 33, "Text"],
Cell[9183, 238, 527, 9, 78, "Input"],
Cell[9713, 249, 964, 17, 153, "Input"],
Cell[10680, 268, 439, 7, 99, "Input"],
Cell[11122, 277, 2117, 36, 474, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13288, 319, 25, 0, 69, "Section"],

Cell[CellGroupData[{
Cell[13338, 323, 43, 0, 39, "Subsubsection"],
Cell[13384, 325, 858, 18, 162, "Input"],
Cell[14245, 345, 486, 8, 141, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14768, 358, 39, 0, 39, "Subsubsection"],
Cell[14810, 360, 851, 18, 162, "Input"],
Cell[15664, 380, 480, 9, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16181, 394, 55, 0, 39, "Subsubsection"],
Cell[16239, 396, 866, 18, 162, "Input"],
Cell[17108, 416, 478, 9, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17623, 430, 32, 0, 39, "Subsubsection"],
Cell[17658, 432, 863, 18, 162, "Input"],
Cell[18524, 452, 512, 10, 120, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19073, 467, 52, 0, 39, "Subsubsection"],
Cell[19128, 469, 861, 18, 162, "Input"],
Cell[19992, 489, 478, 9, 120, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

