function [vec,rot]=emag_igrf(year,lat,lon,R_sat,nmax)
% Input:
% year=2010.0 to 2015.0
% lat latitude  in [rad]
% lon longitude in [rad]
% R_sat = R_e + alt in [ksm]
% nmax is order 0...13
%
% Output:
% vec magnetic field vector in unit Tesla [T] in world coordinates
% coordinate transformation from XYZ to world coordinates

if ~nargin
  fprintf('\n please run\n  emag_lines, or\n  emag_norm\n for example\n\n')
  return
end

  emag_data
  ght =gh2010+(year-2010)*Dgd2010;
  sl  =[sin(lon) zeros(1, 13)];
  cl  =[cos(lon) zeros(1, 13)];
  p   =zeros(1,119);
  q   =zeros(1,119);
  slat=sin(lat);
  clat=cos(lat);
  x=0;
  y=0;
  z=0;
  sd=0;
  cd=1;
  l=1;
  n=0;
  m=1;
  aa=sqrt(3);
  p(1)=2*slat;
  p(2)=2*clat;
  p(3)=4.5*slat*slat-1.5;
  p(4)=3*aa*clat*slat;
  q(1)=-clat;
  q(2)= slat;
  q(3)=-3*clat*slat;
  q(4)=aa*(slat*slat-clat*clat);
  for k=1:nmax*(nmax+3)/2
    if n<m
      m=0;
      n=n+1;
      rr=(6371.2/R_sat)^(n+2);
      fn=n;
    end
    fm=m;
    if k>=5
      if m==n
        aa=sqrt(1-0.5/fm);
        j =k-n-1;
        p (k)=(1+1/fm)*aa*clat*p(j);
        q (k)=aa*(clat*q(j)+slat/fm*p(j));
        sl(m)=sl(m-1)*cl(1)+cl(m-1)*sl(1);
        cl(m)=cl(m-1)*cl(1)-sl(m-1)*sl(1);
      else
        aa=sqrt(fn*fn-fm*fm);
        bb=sqrt((fn-1)*(fn-1)-fm*fm)/aa;
        cc=(2*fn-1)/aa;
        ii=k-n;
        j =k-2*n+1;
        p(k)=(fn+1)*(cc*slat/fn*p(ii)-bb/(fn-1)*p(j));
        q(k)=cc*(slat*q(ii)-clat/fn*p(ii))-bb*q(j);
      end
    end
    aa=rr*ght(l);
    if m==0    
      x=x+aa*q(k);
      z=z-aa*p(k);      
      l=l+1;
    else
      bb=rr*ght(l+1);
      cc=aa*cl(m)+bb*sl(m);
      x=x+cc*q(k);
      z=z-cc*p(k);
      if clat>0
        y=y+(aa*sl(m)-bb*cl(m))*fm*p(k)/((fn+1)*clat);
      else
        y=y+(aa*sl(m)-bb*cl(m))*q(k)*slat;
      end
      l=l+2;
    end
    m=m+1;
  end
  aa=x;
  x=x*cd+z *sd;
  z=z*cd-aa*sd;  
  rot=[-sin(lat)*cos(lon) -sin(lon) -cos(lat)*cos(lon)
       -sin(lat)*sin(lon)  cos(lon) -cos(lat)*sin(lon)
        cos(lat)           0        -sin(lat)         ];                  
  vec=1e-9*rot*[x y z]';
