function emag_lines(year,alt,resol)

R_e=6371.2;

if ~nargin
  emag_lines(2012.75,350,15)
  return
end

[x,y,z]=sphere(30);
lat=asin (z);
lon=atan2(y,x);

u=x;
v=y;
w=z;

for c1=1:numel(lat)
  [vec,rot]=emag_igrf(year,lat(c1),lon(c1),R_e+alt,13);
  u(c1)=vec(1);
  v(c1)=vec(2);
  w(c1)=vec(3);
end

clf reset
set(1,'Position',[100 100 720 720])
set(1,'Color',[0 0 0])
subplot('Position',[0 0 1 1])

img=imread('earth.jpg');
sY=size(img,2);
sY4=ceil(sY/4);
img=img(:,[sY4:end 1:sY4-1],:);
img=imrotate(img,180);

warp(x*R_e,y*R_e,z*R_e,img)
alpha(0.75)
axis equal
hold on
view(30,70)
view(0,0)
view(109,14)
xlabel('x')
ylabel('y')
zlabel('z')

rad=R_e+alt;
quiver3(x*rad,y*rad,z*rad,u,v,w,'r')

[x,y,z]=sphere(resol);
x([1 end],:)=[]; % remove pole coordinates
y([1 end],:)=[]; % remove pole coordinates
z([1 end],:)=[]; % remove pole coordinates

for c1=1:numel(x)
  pos=R_e*[x(c1) y(c1) z(c1)]';
  cel=jiiterate(year,pos);
  if ~isempty(cel)
    plot3(cel(1,:),cel(2,:),cel(3,:),'w.-');
  end
end

rad=R_e+2000;
axis([-rad rad -rad rad -rad rad])
axis off

function grd=jigrad(year,pos)
  [x,y,z]=deal(pos(1),pos(2),pos(3));
  rad=norm(pos);
  grd=emag_igrf(year,asin(z/rad),atan2(y,x),rad,13);

function res=jirungekutta(h,year,pos)
  k1=h*jigrad(year,pos       );
  k2=h*jigrad(year,pos+0.5*k1);
  k3=h*jigrad(year,pos+0.5*k2);
  k4=h*jigrad(year,pos+    k3);
  res=pos+(k1+2*k2+2*k3+k4)/6;

function ret=jiiterate(year,pos1)
  R_e=6371.2;
  h=7.5e6;
  pos=pos1;
  cel=cell(1,0);
  while numel(cel)<100
    pos=jirungekutta(-h,year,pos);
    alt=norm(pos);
    cel{end+1}=pos;
    if alt < R_e-1 || R_e+2000 < alt
      break;
    end
  end  
  ret=[fliplr(cell2mat(cel)) pos1];
  
  pos=pos1;
  cel=cell(1,0);
  while numel(cel)<100
    pos=jirungekutta(h,year,pos);
    alt=norm(pos);
    cel{end+1}=pos;
    if alt < R_e-1 || R_e+2000 < alt
      break;
    end
  end  
  ret=[ret cell2mat(cel)];


  
