function emag_norm(year,alt,resol)
persistent cnt img

R_e=6371.2;

if ~nargin
  cnt=0;
  for year=2010:1:2015
    emag_norm(year,350,15)
    pause(eps)
  end
  return
end


[lon,lat]=meshgrid(linspace(-pi,pi,91),linspace(-pi/2,pi/2,46));
nrm=lon;

for c1=1:numel(lat)
  [vec,rot]=emag_igrf(year,lat(c1),lon(c1),R_e+alt,13);
  nrm(c1)=norm(vec);
end

rad2deg=180/pi;

clf reset
%earth.jpg 614 307
set(1,'Position',[100 100 615 308])
set(1,'Color',[0 0 0])
subplot('Position',[0 0 1 1])
[c,h]=contour(lon*rad2deg,lat*rad2deg,nrm*1e6,unique([22 27 15:5:65]));
if ~cnt
  clabel(c,h,'Color', 'w');
  img=imread('earth.jpg');
  for c1=1:3
    img(:,:,c1)=flipud(img(:,:,c1));
  end
end

xlabel('longitude [deg]')
ylabel('latitude [deg]')
axis equal
axis([-180 180 -90 90])
hold on

warp(lon*rad2deg,lat*rad2deg,lon*0+1,img)
txt=text(-180,85,-1,sprintf('01.Jan.%i (in  \\muT, alt. 350 km)',year));
set(txt,'Color',[1 1 1])
set(txt,'BackgroundColor',[0 0 0])
view(0,-90)

